import logging
from fastapi import APIRouter, Request

from scripts.constants.api import APIEndPoints
from scripts.core.handlers.device_handler import AssetHandler
from scripts.database.mongodb.asset_manager.collections.device import Devices
from scripts.errors import ErrorMessages
from scripts.logging.logger import logger
from scripts.schemas.deafult_responses import DefaultResponse
from scripts.schemas.tag_schema import Tag, File

router = APIRouter()

Asset_obj = AssetHandler()


@router.get(APIEndPoints.root, tags=["Asset Manager"])
async def root():
    try:
        return {"API running"}
    except Exception as e:
        logger.error(f"root api failed due to {e}")
        return DefaultResponse(error=ErrorMessages.OP_FAILED)


@router.post(APIEndPoints.create_tag, tags=["creating tags"])
async def tag_creation(payload: Tag):
    try:
        logger.info("creating new tag api called")
        Asset_obj.tag_details(payload)
        return {"data": "tag created"}
    except Exception as e:
        logger.error(f"error from tag creation api {e}")
        return None


@router.post(APIEndPoints.download_file, tags=["download file"])
async def download_file_details(file_details: File):
    try:
        logger.info("download file details api called")
        Asset_obj.store_file_details(file_details)
        return {"data": "file details stored"}
    except Exception as e:
        logger.error(f"error from download file details api")
