class ILensErrors(Exception):
    """Generic iLens Error"""


class AuthenticationError(ILensErrors):
    pass


class ErrorMessages:
    UNKNOWN_ERROR = "Unknown Error Occurred"
    OP_FAILED = "Operation failed"
    RES_FAILED = "Failed To get Details from remote devices"
    # Authorization Errors
    DEVICE_CREATION_FAILED = "Device creation failed. Check your inputs or contact support."
    INVALID_DEVICE_ID = "Device ID is invalid, please check input."


class DeviceCreationError(ILensErrors):
    """
    Raises when device creation or registration fails
    """


class InvalidDeviceIDError(ILensErrors):
    """
    Raise when device ID is invalid or not found
    """
