from scripts.constants.db_constants import DatabaseConstants
from scripts.database.mongodb import CollectionBaseClass, mongo_client
from scripts.database.mongodb.asset_manager import database
from scripts.logging.logger import logger

from scripts.utils.mongo_utils import MongoStageCreator

collection_name = DatabaseConstants.download_file_details
mongo_stage_creator = MongoStageCreator()


class FileDetails(CollectionBaseClass):
    def __init__(self):
        super().__init__(
            mongo_client,
            database=database,
            collection=collection_name
        )
    def fetch_file_name(self,file_data):
        try:
            fetch_file_name = self.find_one(file_data.file_name)
            if fetch_file_name is None:
                logger.info("")

    def store_file_details(self, file_data):
        try:

            if fetch_file_name is None:
                logger.info("new file added")
                result = self.insert_one(file_data)
                if result:
                    return {"file details added"}
                else:
                    return None
            else:
                return {f"{file_data.file_name} already added"}
        except Exception as e:
            logger.error(f"error while storing file details {e}")
            return None
