from typing import Any

from scripts.constants.db_constants import DatabaseConstants
from scripts.database.mongodb import CollectionBaseClass, mongo_client
from scripts.database.mongodb.asset_manager import database
from scripts.logging.logger import logger

from scripts.utils.mongo_utils import MongoStageCreator

collection_name = DatabaseConstants.collection
mongo_stage_creator = MongoStageCreator()


class Devices(CollectionBaseClass):
    def __init__(self):
        super().__init__(
            mongo_client,
            database=database,
            collection=collection_name
        )

    def update_details(self, filter, update):
        try:
            logger.info("Update name method called")
            # Call the update_one method to update the document
            result = self.update_one(filter, update)
            if result:
                return result.modified_count
            return None

        except Exception as e:
            logger.error(f"error from device.py {e}")
            return None

    def create_tag(self, filter, update):
        try:
            logger.info("creating new tag")
            result = self.update_one(filter, update)
            if result:
                return result.modified_count
            return None
        except Exception as e:
            logger.error(f"error from creating new tag {e}")
