from scripts.database.mongodb.asset_manager.collections.device import Devices
from scripts.database.mongodb.asset_manager.collections.download_file import FileDetails
from scripts.logging.logger import logger

obj = Devices()
file_obj = FileDetails()


class AssetHandler:
    @staticmethod
    def update_db(data):
        try:
            logger.info("create tags called")
            # Construct the filter to match the document with the given _id
            filter = {"mac_address": data.mac}
            # Construct the update document to set the customer field to "ARJUN B"
            update = {"site_location.country": data.country,
                      "site_location.state": data.state,
                      "vendor": data.vendor,
                      "customer": data.customer
                      }
            data = obj.update_details(filter, update)
            if data:
                logger.info("database updated")
            else:
                return None

        except Exception as e:
            logger.error(f"error from handler {e}")
            return None

    @staticmethod
    def tag_details(details):

        try:
            logger.info("new tag created.....")
            # fetching the tag details
            # Construct the filter to match the document with the given _id
            fetch = {"mac_address": details.mac}

            data = {"country": details.country,
                    "state": details.state,
                    "vendor": details.vendor,
                    "device": details.device,
                    "customer": details.customer
                    }
            db_update = obj.create_tag(fetch, data)

            if db_update:
                logger.info("new tag created")
            else:
                return None

        except Exception as e:
            logger.error(f"error from handler {e}")

    @staticmethod
    def store_file_details(file_data):
        try:
            logger.info("new file added into db")
            data = {"file_name": file_data.file_name,
                    "value": file_data.link}
            file_store = file_obj.store_file_details(data)
            if file_store:
                logger.info("file details inserted")
            else:
                return None
        except Exception as e:
            logger.error(f"error in storing the file detalis {e}")
