import __version__
__author__ = 'INT- 714: Arjun B'
__version__ = __version__.__version__
__date__ = '15 May 2023'

import uvicorn

from scripts.config import Services
import argparse
from scripts.logging.logger import logger

# starting the application
ap = argparse.ArgumentParser()

if __name__ == "__main__":
    try:
        logger.info(f"****Starting {Services.PROJECT_NAME} v.{__version__}***")
        print(f"****************************Starting {Services.PROJECT_NAME} {__version__}****************************")
        # creating the argument for the port
        ap.add_argument(
            "--port",
            "-p",
            required=False,
            default=Services.PORT,
            help="Port to start the application.",
        )
        # creating the argument for the host
        ap.add_argument(
            "--bind",
            "-b",
            required=False,
            default=Services.HOST,
            help="IF to start the application.",
        )
        ap.add_argument(
            "--workers",
            "-w",
            type=int,
            default=Services.WORKERS,
            help="Number of worker processes to use.",
        )
        arguments = vars(ap.parse_args())
        # logging the info
        logger.info(f"App Starting at {arguments['bind']}:{arguments['port']} with {arguments['workers']} workers.")
        uvicorn.run(
            "main:app",
            host=arguments["bind"],
            port=int(arguments["port"]),
            workers=arguments["workers"]
        )
    except Exception as e:
        logger.exception(f'Services Failed with error from app {e}')

