import logging
from fastapi import APIRouter, Request

from scripts.constants.api import APIEndPoints
from scripts.database.mongodb.asset_manager.collections.device import Devices
from scripts.logging.logger import logger
from scripts.schemas.test_schema import TestUpdate

router = APIRouter()
obj = Devices()


@router.post(APIEndPoints.api_create, tags=["tag api"])
async def store_tag():
    logger.info("tag of a device is stored")
    try:
        # payload=await response.body()
        # status=
        return {"data": "api running successfully"}
    except Exception as e:
        logger.error(f"error from asset_management")


@router.post(APIEndPoints.db_test, tags=["update test"])
async def update_db(data: TestUpdate):
    try:
        logger.info("update method called")
        obj.update_name(data.mac)
        return {"data": "updated"}
    except Exception as e:
        logger.error(f"error from asset management.py {e}")
