from typing import Any

from scripts.constants.db_constants import DatabaseConstants
from scripts.database.mongodb import CollectionBaseClass, mongo_client
from scripts.database.mongodb.asset_manager import database
from scripts.logging.logger import logger
from scripts.schemas.test_schema import TestUpdate
from scripts.utils.mongo_utils import MongoStageCreator

collection_name = DatabaseConstants.collection
mongo_stage_creator = MongoStageCreator()


class Devices(CollectionBaseClass):
    def __init__(self):
        super().__init__(
            mongo_client,
            database=database,
            collection=collection_name
        )

    def update_name(self, mac):
        # Construct the filter to match the document with the given _id
        filter = {"mac_address": mac}

        # Construct the update document to set the customer field to "ARJUN B"
        update = {"customer": "ARJUN B"}

        # Call the update_one method to update the document
        result = self.update_one(filter, update)

        # Print the number of documents updated
        print(result.modified_count)

    # def update_db(self, data: TestUpdate) -> Any:
    #     """
    #     :param mac_address:
    #     :return:
    #     """
    #     try:
    #         logger.info("entered check_mac_address function. devices.py")
    #         # self.update_one({"mac_address": mac_address}, {"$set":
    #         #                                                    {"customer": "Arjun B"}})
    #         self.update_one(query={"mac_address": data.mac}, data={"customer": "Arjun B"})
    #         # Device with mac_address already exists
    #
    #     except Exception as e:
    #         logger.error(f"error from check_mac_address() - {e}")
    #         return False

