from pydantic import BaseSettings, Field
from dotenv import load_dotenv
load_dotenv()
PROJECT_NAME = "assets_manager_V2"


class _Services(BaseSettings):
    HOST: str = Field(default="127.0.0.1", env="service_host")
    PORT: int = Field(default=8000, env="service_port")
    PROJECT_NAME = Field(default="AssetManager", env="project_name")
    ENCODING_TYPE = Field(default="utf-8", env="encoding_type")
    ENABLE_CORS: bool = True
    CORS_URLS: list = ["*.ilens.io"]
    CORS_ALLOW_CREDENTIALS: bool = True
    CORS_ALLOW_METHODS: list = ["GET", "POST"]
    CORS_ALLOW_HEADERS: list = ["*"]
    LOG_LEVEL: str
    BACKUP_COUNT: int
    MAX_BYTES: int
    ENABLE_FILE_LOGGING: bool = True
    ENABLE_BACKUP_STORING: bool = Field(default=False, env="enable_backup")
    WORKERS: int = Field(default=1, env="workers")


class _Databases(BaseSettings):
    MONGO_URI: str
    BACKUP_DB: str


class _BasePathConf(BaseSettings):
    BASE_PATH: str = "/"


class _PathConf(BaseSettings):
    LOG_PATH: str
    CONFIG_PATH: str
    DEVICE_LIST_PATH: str
    YML_PATH: str


Services = _Services()
Databases = _Databases()
PathConf = _PathConf()

__all__ = [
    "PROJECT_NAME",
    "Services",
    "Databases",
    "PathConf",

]
