from scripts.db.mongo import mongo_client
from scripts.db.mongo.collections.constants import Constants
from scripts.logging.logger import logger


class UpdateHandler:
    def __init__(self):
        self.constants_mongo = Constants(mongo_client=mongo_client)

    def constants_update(self):
        try:
            status = False
            constants_records = self.constants_mongo.find_constant(_type="site_template")
            data = constants_records.get("data")
            for each in data:
                if each.get("key_list"):
                    try:
                        target_index = each.get("key_list").index("equipment")
                    except ValueError as e:
                        logger.debug("Equipment Index not found")
                        target_index = None
                    final_list = each.get("key_list")[:target_index]
                    each.update({"access_key_list": final_list})
            print(data)
            logger.debug(f'constant data: {data}')
            self.constants_mongo.update_one(query={"type": "site_template"}, data={"data": data})
            status = True
            return status
        except Exception as e:
            logger.exception(str(e))
            raise
