from pydantic import BaseSettings
import sys
import yaml


# this method is to read the configuration from backup.conf
def read_configuration(file_name):
    """
    :param file_name:
    :return: all the configuration constants
    """
    with open(file_name, 'r') as stream:
        try:
            return yaml.full_load(stream)
        except yaml.YAMLError as exc:
            print(exc)


config = read_configuration("conf/service.yml")


class _Configuration(BaseSettings):
    MONGO_URI = config["mongo_db"]["URI"]


_conf = _Configuration()


class DB(object):
    class MongoDb:
        uri = _conf.MONGO_URI
        print(uri)
        if not uri:
            print("Error, environment variable MONGO_URI not set")
            sys.exit(1)


class LOG:
    LOG_FILE_NAME = config["log"]["file_name"]
    LOG_PATH = config["log"]["path"]
    LOG_LEVEL = config["log"]["level"]
    LOG_HANDLER = config["log"]["handler"]
    LOG_MAX_BYTES = int(config["log"]["max_bytes"])
    LOG_BACKUP_COUNT = int(config["log"]["back_up_count"])
