from fastapi import APIRouter, Depends

from scripts.api import EndPoints
from scripts.core.handlers.ut_handler import UTHandler
from scripts.logging import logger
from scripts.schemas.response_models import (DefaultFailureResponse,
                                             DefaultResponse)
from scripts.schemas.ut_schema import GetSample, GetTableData

ut_router = APIRouter(prefix=EndPoints.api_ut, tags=["UT Sample Service"])


# @ut_router.post(EndPoints.api_get_sample)
# async def get_sample_data(
#     request_data: GetSample, meta: MetaInfoSchema = Depends(get_cookies)
# ):
#     """
#     API to get sample data
#     """
#     try:
#         ut_handler = UTHandler(project_id=meta.project_id)
#         response = await ut_handler.get_sample_data(request_data)
#         return DefaultResponse(message="Success", data=response)
#     except Exception as e:
#         logger.exception(f"Exception while getting sample data: {e}")
#         return DefaultFailureResponse(
#             message="Failed to get sample", error=str(e)
#         ).dict()


@ut_router.post(EndPoints.api_get_batch_app_data)
async def get_batch_app_data(
    request_data: GetSample
):
    """
    API to get sample data
    """
    try:
        # ut_handler = UTHandler(project_id=meta.project_id)
        response = await UTHandler().get_batch_info_neo_4j(request_data)
        return DefaultResponse(message="Success", data=response)
    except Exception as e:
        logger.exception(f"Exception while getting sample data: {e}")
        return DefaultFailureResponse(
            message="Failed to get sample", error=str(e)
        ).dict()

@ut_router.post(EndPoints.api_get_batch_parameter_table_data)
async def get_batch_table_data(
    request_data: GetTableData
):
    """
    API to get sample data
    """
    try:
        # ut_handler = UTHandler(project_id=meta.project_id)
        response = await UTHandler().get_batch_parameter_table_data(request_data)
        return DefaultResponse(message="Success", data=response)
    except Exception as e:
        logger.exception(f"Exception while getting sample data: {e}")
        return DefaultFailureResponse(
            message="Failed to get sample", error=str(e)
        ).dict()


@ut_router.post(EndPoints.api_get_raw_material_data)
async def get_raw_table_data(
    request_data: GetTableData
):
    """
    API to get sample data
    """
    try:
        # ut_handler = UTHandler(project_id=meta.project_id)
        response = await UTHandler().get_raw_material_table_data(request_data)
        return DefaultResponse(message="Success", data=response)
    except Exception as e:
        logger.exception(f"Exception while getting sample data: {e}")
        return DefaultFailureResponse(
            message="Failed to get sample", error=str(e)
        ).dict()


@ut_router.post(EndPoints.api_get_non_complains_data)
async def get_compliance_table_data(
    request_data: GetTableData
):
    """
    API to get sample data
    """
    try:
        # ut_handler = UTHandler(project_id=meta.project_id)
        response = await UTHandler().get_non_compliance_table_data(request_data)
        return DefaultResponse(message="Success", data=response)
    except Exception as e:
        logger.exception(f"Exception while getting sample data: {e}")
        return DefaultFailureResponse(
            message="Failed to get sample", error=str(e)
        ).dict()