class ILensErrors(Exception):
    """Generic iLens Error"""


class KairosDBError(ILensErrors):
    """Kairos DB Error"""


class AuthenticationError(ILensErrors):
    pass


class DataFrameFormationError(ILensErrors):
    """Raise when there is an error during dataframe formation"""


class ErrorMessages:
    UNKNOWN_ERROR = "Error occurred while processing your request."
    ERROR001 = "Authentication Failed. Please verify token"
    ERROR002 = "Signature Expired"
    ERROR003 = "Signature Not Valid"
    ERROR004 = "No Data available to form dataframe"
    ERROR005 = "Error occurred While forming chart"
    ERROR006 = "Data Not Found"


class IllegalTimeSelectionError(ILensErrors):
    pass


class TemplateFormationError(ILensErrors):
    pass


class ProductsNotFoundError(ILensErrors):
    """Raise when products matching conditions are not found"""

    pass


class DataNotFound(ILensErrors):
    """
    Raise when data is not found
    """


class TagDetailsNotFound(Exception):
    """
    Raise when tag details are crucial to proceed and meta service returns empty list
    """


class DuplicateName(ILensErrors):
    pass


class InputRequestError(Exception):
    pass


class JWTDecodingError(Exception):
    pass


class DashboardNotFound(ILensErrors):
    pass


class WidgetsNotFound(ILensErrors):
    pass


class JobCreationError(Exception):
    """
    Raised when a Job Creation throws an exception.

    Job Creation happens by adding a record to Mongo.
    """


class TemplateNotFoundError(Exception):
    """
    This error is raised when Dashboard/Widget Template is not found
    """


class ChartFormationError(Exception):
    pass


class QueryFormationError(Exception):
    pass


class UnauthorizedError(Exception):
    pass


class PostgresDBError(Exception):
    pass


class CustomError(Exception):
    pass
