# importing libraries
from fastapi import APIRouter, UploadFile
from scripts.constants.endpoints import EndPoints
from scripts.constants.schema import ticket_booking
from scripts.core.handlers.api_functions import Tickets
from scripts.core.handlers.create_redis_db import redis_db_create
from scripts.core.handlers.get_all_seats import seat_availability
from scripts.database.RedisDB.db_connection import conn
from scripts.logging.logger import logger
import pandas as pd

# Create FastAPI instance
router = APIRouter()


# Root
@router.get(EndPoints.root)
async def root():
    return {"Message": "It's Working!"}


@router.get(EndPoints.seat_availability)
def check_seats(ticket_class: str):
    message = seat_availability(conn, ticket_class)
    return message


@router.post(EndPoints.book_ticket, tags=["Ticket Booking"])
async def book_ticket(details: ticket_booking):
    try:
        return Tickets().insert_data_into_db(details)
    except Exception as e:
        logger.error(e)
        print("error ", e)


@router.get(EndPoints.get_booking_details, tags=["get booking details"])
def get_booking_details():
    try:
        Tickets().get_details()
        return {"data": "list all the data"}
    except Exception as e:
        logger.error(e)
        print(e)


@router.get(EndPoints.get_booking_details_between, tags=["get booking details between"])
def get_booking_details_between(from_date: str, to_date: str):
    Tickets().get_details_between(from_date, to_date)
    return {"Message": f"Data stored on file from {from_date} to {to_date}."}


@router.get(EndPoints.show_begin, tags=["show_begin"])
def generate_seats():
    try:
        redis_db_create(conn, "gold", 30, 300)
        redis_db_create(conn, "silver", 25, 125)
        return "booking started"
    except Exception as e:
        logger.error(e)
        print(e)


@router.post(EndPoints.booking_details_json, tags=["Create Json File"])
async def booking_details_json_format(file: UploadFile):
    try:
        excel_file = pd.read_excel(await file.read())
        excel_filename = file.filename
        message = Tickets().json_data(excel_filename, excel_file)
        return message
    except Exception as e:
        logger.error(e)
