from sqlalchemy import create_engine
from sqlalchemy.orm import sessionmaker
from scripts.config.application_config import postgres_uri
from scripts.database.postgresql.model import Base
from scripts.logging.logger import logger


def db_connect():
    try:
        engine = create_engine(postgres_uri)
        sessions = sessionmaker(autocommit=False, autoflush=False, bind=engine)
        Base.metadata.create_all(engine)
        session = sessions()
        return session
    except Exception as e:
        logger.error(e)
