import base64
import json
import socket

from scripts.constants.app_variables import DataPool
from scripts.logging.logger import logger


class UDPSub:
    def __init__(self, host, port, buffer_size):
        try:
            receiver_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
            receiver_socket.bind((host, int(port)))
            while True:
                logger.trace("Entered in UDPSub")
                temp_pool = []
                data_received, _ = receiver_socket.recvfrom(buffer_size)
                decoded_message = json.loads(base64.b64decode(data_received).decode())
                logger.trace(f"decoded_message:{decoded_message}")
                data = decoded_message.get("data").get("data")
                for key, value in data.items():
                    temp_pool.append(int(value.get('dq')))
                logger.trace(f"temp_pool : {temp_pool}")
                DataPool.data_pool = temp_pool
                logger.info(f"data added - {DataPool.data_pool}")
                logger.trace("Exiting from UDPSub")
        except Exception as e:
            logger.exception(f"Exception occurred while subscribing local udp uploader - {e}.")
