from yaml import safe_load


with open("conf/config.yml", 'r') as file:
    config_data = safe_load(file)


class AppConfig:
    data_check_frequency = int(config_data.get("data_check_frequency", 120))
    quality_time_frequency = int(config_data.get("quality_time_frequency", 5))
    acquisition_restart_frequency = int(config_data.get("acquisition_restart_frequency", 2))

    event_uploader_type = config_data.get("event_uploader", {}).get("type", "")
    event_uploader_host_ip = config_data.get("event_uploader", {}).get("host_ip", "")
    event_uploader_port = config_data.get("event_uploader", {}).get("port", None)

    start_delay_time = int(config_data.get("start_delay_time", 0))
    resync_time = config_data.get("primary_device", {}).get("resync_time", "00:15")
    run_time = int(config_data.get("primary_device", {}).get("heartbeat_interval", 120))
    files_to_watch = config_data.get("primary_device", {}).get("folders_to_watch", "")

    host_ip = config_data.get("secondary_device", {}).get("host_ip", "")
    port_no = int(config_data.get("secondary_device", {}).get("port", 8088))
    is_data_source = config_data.get("data_source", False)

    local_uploader_type = config_data.get("local_uploader", {}).get("type", "")
    local_uploader_ip = config_data.get("local_uploader", {}).get("host_ip", "")
    local_uploader_port = int(config_data.get("local_uploader", {}).get("port", 20015))
    local_uploader_username = config_data.get("local_uploader", {}).get("username", "")
    local_uploader_password = config_data.get("local_uploader", {}).get("password", "")

    channel_uploader_host = config_data.get("config", {}).get("channel", {}).get("uploader_host", "")
    channel_uploader_port = config_data.get("config", {}).get("channel", {}).get("uploader_port", 9876)

    agent_base_url = config_data.get("config", {}).get("agent", {}).get("base_url", "")
    agent_project_id = config_data.get("config", {}).get("agent", {}).get("project_id", "")
    agent_device_id = config_data.get("config", {}).get("agent", {}).get("device_id", "")

    monitoring_engine_host = config_data.get("config", {}).get("monitoring_engine", {}).get("host_ip", "")
    monitoring_engine_port = config_data.get("config", {}).get("monitoring_engine", {}).get("port", 9876)
    monitoring_engine_url = config_data.get("config", {}).get("monitoring_engine", {}).get("url", "")


class LoggerConfigurations:
    LEVEL: str = config_data.get("logger", {}).get("level", "INFO")
    HANDLERS: str = config_data.get("logger", {}).get("handlers", "")

app_config = AppConfig()
