import json

import paho.mqtt.client as mqtt

from scripts.constants.app_variables import DataPool, DeviceInfo
from scripts.logging.logger import logger


class MQTTSub(object):

    def __init__(self, host, port, topic, username, password):
        DataPool.data_pool = []
        self.topic = topic
        self.client = mqtt.Client()
        logger.debug(f"Listener MQTT Details {host}:{port}")
        if username and password:
            self.client.username_pw_set(username, password)
        self.client.on_connect = self.on_connect
        self.client.on_message = self.on_message
        try:
            self.client.connect(host=host, port=int(port), keepalive=60)
            self.client.reconnect_delay_set(min_delay=1, max_delay=120)
        except Exception as es:
            logger.exception(f"Exception while connecting to MQTT: {es}")
        self.client.loop_forever()

    def on_connect(self, client, userdata, flags, rc):
        if rc == 0:
            logger.info("MQTT: Connected successfully!")
            self.subscribe()
        else:
            logger.error(f"MQTT: Failed to connect, return code {rc}")

    def on_message(self, client, userdata, msg):
        logger.trace("Entering in mqtt - on_message")
        try:
            temp_data_pool = []
            message = json.loads(msg.payload.decode())
            logger.info(f"message - {message}")
            device_id = message.get("a_id")
            if device_id == DeviceInfo.device_id:
                data = message.get("data")
                for key, value in data.items():
                    temp_data_pool.append(int(value.get('dq')))
                DataPool.data_pool = temp_data_pool
                logger.trace(f"data added in data pool - {DataPool.data_pool}")
        except Exception as es:
            logger.error(f'Exception while fetching data : {es}')
        logger.trace("Exiting from mqtt - on_message")

    def subscribe(self):
        try:
            logger.info(f"Subscribing to topic: {self.topic}")
            self.client.subscribe(self.topic)
        except Exception as es:
            logger.exception(f"Error subscribing to topic {self.topic}: {es}")
