# import logging
# import os
# from logging.handlers import RotatingFileHandler
#
#
# logger_topic = None
# logging.trace = logging.DEBUG - 5
# logging.addLevelName(logging.DEBUG - 5, "TRACE")
#
# class EngineLoggerClass(logging.getLoggerClass()):
#     def __init__(self, name):
#         super().__init__(name)
#
#     def trace(self, msg, *args, **kwargs):
#         if self.isEnabledFor(logging.trace):
#             self._log(logging.trace, msg, args, **kwargs)
#
#     def info(self, msg, *args, **kwargs):
#         if self.isEnabledFor(logging.INFO):
#             self._log(logging.INFO, msg, args, **kwargs)
#
#     def debug(self, msg, *args, **kwargs):
#         if self.isEnabledFor(logging.DEBUG):
#             self._log(logging.DEBUG, msg, args, **kwargs)
#
#     def warning(self, msg, *args, **kwargs):
#         if self.isEnabledFor(logging.WARNING):
#             self._log(logging.WARNING, msg, args, **kwargs)
#
#     def error(self, msg, *args, **kwargs):
#         if self.isEnabledFor(logging.ERROR):
#             self._log(logging.ERROR, msg, args, **kwargs, extra={"__logger_topic__": logger_topic})
#
#     def critical(self, msg, *args, **kwargs):
#         if self.isEnabledFor(logging.CRITICAL):
#             self._log(logging.CRITICAL, msg, args, **kwargs)
#
# def get_logger():
#     """
#      Creates a rotating log
#      """
#     logging.setLoggerClass(EngineLoggerClass)
#     __logger__ = logging.getLogger('')
#
#     # setting the logger level
#     __logger__.setLevel("INFO")
#
#     # creating the format for the log
#     log_formatter = "%(asctime)s-%(levelname)-s-[%(funcName)5s():%(lineno)s]-%(message)s"
#     time_format = "%Y-%m-%d %H:%M:%S"
#
#     # getting the path for the logger
#     file_path = "logs"
#
#     # setting the format
#     formatter = logging.Formatter(log_formatter, time_format)
#
#     # creating the folder if not exist
#     if not os.path.exists(file_path):
#         os.makedirs(file_path)
#
#     # joining the path
#     log_file = os.path.join(f"{file_path}/redundancy.log")
#
#     # creating rotating file handler with max byte as 1
#     temp_handler = RotatingFileHandler(log_file,
#                                        maxBytes=1000000000,
#                                        backupCount=5)
#
#     # setting the formatter
#     temp_handler.setFormatter(formatter)
#
#     # setting the handler
#     __logger__.addHandler(temp_handler)
#
#     return __logger__
#
#
# logger = get_logger()


import json
import logging
import os
from logging.handlers import RotatingFileHandler

from scripts.constants.app_config import LoggerConfigurations

logger_topic = None
logging.trace = logging.DEBUG - 5
logging.addLevelName(logging.DEBUG - 5, "TRACE")


class EngineLoggerClass(logging.getLoggerClass()):
    def __init__(self, name):
        super().__init__(name)

    def trace(self, msg, *args, **kwargs):
        if self.isEnabledFor(logging.trace):
            self._log(logging.trace, msg, args, **kwargs)

    def info(self, msg, *args, **kwargs):
        if self.isEnabledFor(logging.INFO):
            self._log(logging.INFO, msg, args, **kwargs)

    def debug(self, msg, *args, **kwargs):
        if self.isEnabledFor(logging.DEBUG):
            self._log(logging.DEBUG, msg, args, **kwargs)

    def warning(self, msg, *args, **kwargs):
        if self.isEnabledFor(logging.WARNING):
            self._log(logging.WARNING, msg, args, **kwargs)

    def error(self, msg, *args, **kwargs):
        if self.isEnabledFor(logging.ERROR):
            self._log(logging.ERROR, msg, args, **kwargs, extra={"__logger_topic__": logger_topic})

    def critical(self, msg, *args, **kwargs):
        if self.isEnabledFor(logging.CRITICAL):
            self._log(logging.CRITICAL, msg, args, **kwargs)


class CustomRotatingFileHandler(RotatingFileHandler):
    def emit(self, record):
        msg = self.format(record)
        try:
            is_eventhandler_present = any(
                loggers.get("type") == "eventhandler" for loggers in LoggerConfigurations.HANDLERS)
            if "$" in msg and ("events_constants" in msg or "error_constants" in msg) and not is_eventhandler_present:
                error_json = {}
                msg_list = msg.split("$")
                error_json["Desc"] = msg_list[2].split(':')[0]
                try:
                    error_json["ErrorDetails"] = json.loads(msg_list[3].replace("'", '"'))
                    error_json["PythonDesc"] = msg_list[4]
                except:
                    pass
                error_return = f"{error_json.get('Desc', '')} {error_json.get('PythonDesc', '')}".strip()
                record.msg = error_return
                record.exc_text = None
                record.exc_info = None
            super().emit(record)
        except:
            pass


def get_logger(name):
    """
    Creates a rotating log
    """

    time_format = "%Y-%m-%d %H:%M:%S"
    log_level = LoggerConfigurations.LEVEL
    logging.setLoggerClass(EngineLoggerClass)
    __logger__ = logging.getLogger(name)
    __logger__.setLevel(log_level.strip().upper())
    debug_formatter = (
        "%(asctime)s-%(levelname)-3s-" "[%(filename)5s:" "%(lineno)s] -> %(message)s"
    )
    formatter_string = (
        "%(asctime)s - %(levelname)-6s - %(name)s - %(levelname)3s - %(message)s"
    )

    if log_level.strip().upper() == log_level:
        formatter_string = debug_formatter
    formatter = logging.Formatter(formatter_string, time_format)
    for handler in LoggerConfigurations.HANDLERS:
        if handler["type"].lower() == "rotatingfilehandler":
            os.makedirs(handler["file_path"], exist_ok=True)
            log_file = f'{handler["file_path"]}/{name.replace(".", "_").replace("/", "_").replace(" ", "_")}.log'

            temp_handler = CustomRotatingFileHandler(
                log_file,
                maxBytes=int(handler["max_bytes"]),
                backupCount=int(handler["back_up_count"]),
            )
            temp_handler.setFormatter(formatter)
        if handler["type"].lower() == "streamhandler" or os.environ.get('ENABLE_CONSOLE_LOG', default=False):
            temp_handler = logging.StreamHandler()
            temp_handler.setFormatter(formatter)
        __logger__.addHandler(temp_handler)
    return __logger__


logger = get_logger(name="application")
