class EventConstants:
    payload_template = {
        "timestamp": "",
        "project_id": "",
        "logged_by": "iLens Redundancy",
        "event_code": "",
        "event_category": "",
        "event_type": "",
        "event_description": "",
        "source_description": "iLens Redundancy Module",
        "hierarchy": "",
        "level": "",
        "ilens_device_id": "",
        "event_details": {}
    }

    daily_sync = "IR-PI001"
    pipeline_modification = "IR-PI002"
    configuration_modification = "IR-PI003"
    pipeline_mismatch = "IR-PI004"
    primary_acq_stopped = "IR-PI005"

    configuration_sync = "IR-SI001"
    pipeline_updated = "IR-SI002"
    configuration_updated = "IR-SI003"
    time_updated = "IR-SI004"
    secondary_acq_restarted = "IR-SI005"
    secondary_acq_restarted_bad_data = "IR-SI006"
    secondary_acq_stopped = "IR-SI007"
    secondary_module_restarted = "IR-SI008"

    bad_data_quality = "IR-PE001"
    primary_acq_stopping_failed = "IR-PE002"

    secondary_acq_restart_failed = "IR-SE001"
    secondary_acq_stopping_failed = "IR-SE002"
    secondary_module_restart_failed = "IR-SE003"

    @staticmethod
    def get_event_description(event_code):
        event_description = {
            "IR-PI001": {
                "event_code": "IR-PI001",
                "event_category": "Daily Sync",
                "event_type": "Daily Configuration sync",
                "event_description": "All the configurations files are transferred to the secondary device.",
                "level": "Information",
            },
            "IR-PI002": {
                "event_code": "IR-PI002",
                "event_category": "Channel Pipeline",
                "event_type": "Pipeline updated",
                "event_description": "Updated changes are transferred to the secondary device.",
                "level": "Information",
            },
            "IR-PI003": {
                "event_code": "IR-PI003",
                "event_category": "Configuration Update",
                "event_type": "Configuration Updated",
                "event_description": "Updated changes are transferred to the secondary device.",
                "level": "Information",
            },
            "IR-PI004": {
                "event_code": "IR-PI004",
                "event_category": "Acquisition Pipeline",
                "event_type": "Pipeline Version Missmatch",
                "event_description": "Sending pipeline to secondary device.",
                "level": "Information",
            },
            "IR-PI005": {
                "event_code": "IR-PI005",
                "event_category": "Acquisition Engine",
                "event_type": "Stopped Acquisition Engine",
                "event_description": "Acquisition engine is stopped on primary device.",
                "level": "Information",
            },
            "IR-SI001": {
                "event_code": "IR-SI001",
                "event_category": "Daily Sync",
                "event_type": "Daily Configuration sync",
                "event_description": "All the configurations files are updated in the secondary device.",
                "level": "Information",
            },
            "IR-SI002": {
                "event_code": "IR-SI002",
                "event_category": "Channel Pipeline",
                "event_type": "Pipeline updated",
                "event_description": "Pipeline changes are updated in the secondary device.",
                "level": "Information",
            },
            "IR-SI003": {
                "event_code": "IR-SI003",
                "event_category": "Configuration Update",
                "event_type": "Configuration Updated",
                "event_description": "Configuration changes are updated in the secondary device.",
                "level": "Information",
            },
            "IR-SI004": {
                "event_code": "IR-SI004",
                "event_category": "Date-Time Update",
                "event_type": "System time updated",
                "event_description": "System Date-time updated in the secondary device.",
                "level": "Information",
            },
            "IR-SI005": {
                "event_code": "IR-SI005",
                "event_category": "Acquisition Engine",
                "event_type": "Module restarted",
                "event_description": "Acquisition engine module restarted due to no response from primary device.",
                "level": "Information",
            },
            "IR-SI006": {
                "event_code": "IR-SI006",
                "event_category": "Acquisition Engine",
                "event_type": "Module restarted",
                "event_description": "Acquisition engine module restarted due to bad quality data in primary device.",
                "level": "Information",
            },
            "IR-SI007": {
                "event_code": "IR-SI007",
                "event_category": "Acquisition Engine",
                "event_type": "Module stopped",
                "event_description": "Acquisition engine module stopped due to primary device came online with proper data",
                "level": "Information",
            },
            "IR-SI008": {
                "event_code": "IR-SI008",
                "event_category": "Module Restarted",
                "event_type": "Module restarted on secondary",
                "event_description": "Successfully restarted the module - ",
                "level": "Information",
            },
            "IR-SE001": {
                "event_code": "IR-SE001",
                "event_category": "Acquisition Engine Error",
                "event_type": "Failed to restart the module.",
                "event_description": "Failed to restart acquisition engine on the secondary device.",
                "level": "Error",
            },
            "IR-SE002": {
                "event_code": "IR-SE002",
                "event_category": "Acquisition Engine Error",
                "event_type": "Failed to stop the module.",
                "event_description": "Failed to stop acquisition engine on the secondary device.",
                "level": "Error",
            },
            "IR-SE003": {
                "event_code": "IR-SE003",
                "event_category": "Module Restarting Error",
                "event_type": "Failed to restart the module.",
                "event_description": "Failed to restart the module - ",
                "level": "Error",
            },
            "IR-PE001": {
                "event_code": "IR-PE001",
                "event_category": "Data Error",
                "event_type": "Bad Quality Data",
                "event_description": "Bad quality data coming in acquisition engine.",
                "level": "Error",
            },
            "IR-PE002": {
                "event_code": "IR-PE002",
                "event_category": "Acquisition Engine Error",
                "event_type": "Failed to stop the module.",
                "event_description": "Failed to stop acquisition engine on the primary device.",
                "level": "Error",
            }
        }
        return event_description[event_code]


events_constants = EventConstants()
