import json

import paho.mqtt.client as mqtt

from scripts.constants.app_variables import DataPool, DeviceInfo
from scripts.logging.logger import logger


class MQTTSub(object):

    def __init__(self, host, port, topic):
        DataPool.data_pool = []
        self.client = mqtt.Client()
        logger.debug(f"Listener MQTT Details {host}:{port}")
        try:
            self.client.connect(host=host, port=int(port))
            self.client.subscribe(topic)
            self.client.loop_start()
        except Exception as es:
            logger.error(f'exception while connection to mqtt : {es}')

        self.client.on_connect = self.on_connect
        self.client.on_message = self.on_message

    def on_connect(self, client, userdata, flags, rc):
        logger.info("MQTT : Connected with result code " + str(rc))

    def on_message(self, client, userdata, msg):
        try:
            logger.info("Entering in mqtt - on_message")
            temp_data_pool = []
            message = json.loads(msg.payload.decode())
            logger.info(f"message - {message}")
            device_id = message.get("a_id")
            if device_id == DeviceInfo.device_id:
                data = message.get("data")
                for key, value in data.items():
                    temp_data_pool.append(int(value.get('dq')))
                DataPool.data_pool = temp_data_pool
            logger.info("Exiting from mqtt - on_message")
        except Exception as es:
            logger.error(f'Exception while fetching data : {es}')
