import subprocess
import time
from datetime import datetime, timedelta

from scripts.constants.app_config import app_config
from scripts.constants.app_constants import constants, services
from scripts.constants.app_variables import TimeVariable
from scripts.constants.events import events_constants
from scripts.logging.logger import logger
from scripts.utilities.communication_util import post_events
from scripts.utilities.service_util import service_operations


class DeviceHandler:
    @staticmethod
    def check_system_time(timestamp_str):
        try:
            logger.info("Entered in check_system_time")
            current_time = datetime.now()
            timestamp = datetime.strptime(timestamp_str, "%Y-%m-%d %H:%M:%S")
            time_difference = current_time - timestamp
            five_minutes = timedelta(minutes=5)
            if time_difference > five_minutes:
                if constants.is_windows:
                    formatted_date = timestamp.strftime("%d-%m-%Y")
                    formatted_time = timestamp.strftime("%H:%M:%S")
                    command = f"date {formatted_date} && time {formatted_time}"
                else:
                    command = f"date -s {timestamp}"
                subprocess.run(command, shell=True)
                post_events(events_constants.time_updated)
                logger.info("System time updated and events send successfully.")
        except Exception as e:
            logger.exception(f"Exception occurred while checking system time - {e}.")
        logger.info("Exiting from check_system_time")

    @staticmethod
    def check_last_hit():
        try:
            while True:
                logger.info("Entered check_last_hit")
                logger.info(
                    f"data const var before checking in check_last_hit entry - {service_operations.check_ilens_client_status()}")
                logger.info(f"TimeVariable.api_last_hit_time in check_last_hit - {TimeVariable.api_last_hit_time}")
                current_time = datetime.now()
                time_difference = current_time - TimeVariable.api_last_hit_time
                logger.info(f"time_difference: {time_difference}")
                waiting_time = timedelta(seconds=(app_config.data_check_frequency * app_config.run_time))
                if time_difference > waiting_time and app_config.is_data_source:
                    if not service_operations.check_ilens_client_status():
                        time.sleep(app_config.start_delay_time)
                        operation_status = service_operations.restart_service(services.acquisition_engine)
                        if operation_status:
                            post_events(events_constants.secondary_acq_restarted)
                            logger.info("Acquisition Engine module started due to no response from primary device.")
                        else:
                            post_events(events_constants.secondary_acq_restart_failed)
                            logger.error("Failed to start the Acquisition Engine module.")
                time.sleep(app_config.run_time)
                logger.info(f"TimeVariable.api_last_hit_time in check_last_hit exit - {TimeVariable.api_last_hit_time}")
                logger.info(
                    f"data const var after checking in check_last_hit - {service_operations.check_ilens_client_status()}")
        except Exception as e:
            logger.exception(f"Exception occurred while checking last hit - {e}.")
        logger.info("Exiting from check_last_hit")

    @staticmethod
    def check_last_quality_data_time(data_check):
        try:
            logger.info("Entered check_last_quality_data_time")
            logger.info(
                f"data const var before checking in check_last_quality_data_time - {service_operations.check_ilens_client_status()}")
            logger.info(
                f"TimeVariable.last_quality_data check_last_quality_data_time entry: {TimeVariable.last_quality_data}")
            if data_check:
                TimeVariable.last_quality_data = datetime.now()
            current_time = datetime.now()
            time_difference = current_time - TimeVariable.last_quality_data
            waiting_time = timedelta(seconds=(app_config.quality_time_frequency * app_config.run_time))
            if time_difference > waiting_time and app_config.is_data_source:
                if not service_operations.check_ilens_client_status():
                    time.sleep(app_config.start_delay_time)
                    operation_status = service_operations.restart_service(services.acquisition_engine)
                    if operation_status:
                        post_events(events_constants.secondary_acq_restarted_bad_data)
                        logger.info("Acquisition Engine module started due to bad quality data in primary device.")
                    else:
                        post_events(events_constants.secondary_acq_restart_failed)
                        logger.error("Failed to start the Acquisition Engine module.")
            elif app_config.is_data_source and service_operations.check_ilens_client_status() and data_check:
                operation_status = service_operations.stop_service(services.acquisition_engine)
                if operation_status:
                    post_events(events_constants.secondary_acq_stopped)
                    logger.info("Acquisition Engine module stopped on secondary device.")
                else:
                    post_events(events_constants.secondary_acq_stopping_failed)
                    logger.error("Failed to stop the Acquisition Engine module on secondary device.")
            logger.info(
                f"data const var after checking in check_last_quality_data_time - {service_operations.check_ilens_client_status()}")
        except Exception as e:
            logger.exception(f"Exception occurred while checking last quality data time - {e}.")
        logger.info(
            f"TimeVariable.last_quality_data check_last_quality_data_time exit: {TimeVariable.last_quality_data}")
        logger.info("Exiting from check_last_quality_data_time")


device_handler = DeviceHandler()
