import os
import platform


class Constants:
    ilens_path = None
    file_path_changes = False
    is_windows = False

    if platform.system().lower() == "windows":
        from scripts.utilities.common_util import WindowsUtilities
        windows_utils = WindowsUtilities()
        file_path_changes = True
        is_windows = True
        ilens_path = windows_utils.find_ilens_folder()
    elif platform.system().lower() == "linux":
        ilens_path = "/iLens"

    conf_path = "conf"
    pipeline_file = "channel.yml"
    file_names = ["channel.yml", "config.yml", "application.conf"]

    local_mqtt_topic = "ilens/monitor/live/#"

    event_topic = "/csv_reader/api/gateway/create_event"

    ilens_agent_path = os.path.join(ilens_path, "ilens-agent")
    engine_path = os.path.join(ilens_agent_path, "engine")
    ilens_client_path = os.path.join(engine_path, "acquisition_engine")
    license_file_path = os.path.join(ilens_agent_path, "license", "license.lic")
    channel_pipeline_path = os.path.join(ilens_client_path, conf_path, pipeline_file)

    secret_key = "RGF0YUFjcXVpc2l0aW9uU3lzdGVtcyBURUFN"


class Services:
    ilens_agent = "ilens-agent"
    acquisition_engine = "ilens_client"
    monitoring_engine = "ilens-clientmonitor"
    ilens_heartbeat = "ilens_heartbeat"
    ilens_data_receiver = "ilens_data_receiver"
    ilens_data_transmitter = "ilens_data_transmitter"
    ilens_events_transmitter = "ilens_events_transmitter"
    ilens_file_transmitter = "ilens_file_transmitter"


services = Services()
constants = Constants()
