from scripts.utilities.common_util import common_utilities

config_data = common_utilities.read_configs("conf/config.yml")


class AppConfig:
    data_check_frequency = int(config_data.get("data_check_frequency"))
    quality_time_frequency = int(config_data.get("quality_time_frequency"))
    acquisition_restart_frequency = int(config_data.get("acquisition_restart_frequency"))

    event_uploader_type = config_data.get("event_uploader").get("type")
    event_uploader_host_ip = config_data.get("event_uploader").get("host_ip")
    event_uploader_port = config_data.get("event_uploader").get("port", None)

    start_delay_time = int(config_data.get("start_delay_time"))
    resync_time = config_data.get("primary_device").get("resync_time")
    run_time = int(config_data.get("primary_device").get("heartbeat_interval"))
    files_to_watch = common_utilities.list_the_files(config_data.get("primary_device").get("files_to_watch"))

    host_ip = config_data.get("secondary_device").get("host_ip")
    port_no = int(config_data.get("secondary_device").get("port"))
    is_data_source = config_data.get("data_source", False)

    local_uploader_type = config_data.get("local_uploader").get("type")
    local_uploader_ip = config_data.get("local_uploader").get("host_ip")
    local_uploader_port = int(config_data.get("local_uploader").get("port"))

    channel_uploader_host = config_data.get("config").get("channel").get("uploader_host")
    channel_uploader_port = config_data.get("config").get("channel").get("uploader_port")

    agent_base_url = config_data.get("config").get("agent").get("base_url")
    agent_project_id = config_data.get("config").get("agent").get("project_id")
    agent_device_id = config_data.get("config").get("agent").get("device_id")

    monitoring_engine_host = config_data.get("config").get("monitoring_engine").get("host_ip")
    monitoring_engine_port = config_data.get("config").get("monitoring_engine").get("port")
    monitoring_engine_url = config_data.get("config").get("monitoring_engine").get("url")


app_config = AppConfig()
