from datetime import datetime

from pydantic import BaseModel, Field


class DeviceDetails(BaseModel):
    device_id: str = Field(default="", description="The ID of the device")
    software_name: str = Field(default="", description="The name of the software running on the device")
    mac_address: str = Field(default="", description="The MAC address of the device")
    site_id: str = Field(default="", description="The ID of the site where the device is located")
    site_name: str = Field(default="", description="The name of the site where the device is located")
    site_location: dict = Field(default={"country": "", "state": "", "city": ""},
                                description="The location of the site where the device is located")
    customer: str = Field(default="", description="The name of the customer that owns the device")
    vendor: str = Field(default="", description="The name of the vendor that supplied the device")
    tags: list = Field(default=[], description="Any tags associated with the device")


class DeviceParameters(BaseModel):
    mac_address: str = Field(default="", description="The MAC address of the device")
    software_name: str = Field(default="", description="The name of the software running on the device")
    ram_total: int = Field(default=0, description="The total amount of RAM on the device")
    ram_percent: float = Field(default=0.00, description="The percentage of RAM used on the device")
    ram_free: int = Field(default=0, description="The amount of free RAM on the device")
    ram_used: int = Field(default=0, description="The amount of RAM used on the device")
    disk: dict = Field(default={}, description="The details of the disk space on the device")
    last_reboot: datetime
    last_sync: datetime
    throttle: str = Field(default="", description="The throttle status of the device")
    io_count: dict = Field(default={"read_count": 0, "write_count": 0, "read_bytes": 0, "write_bytes": 0,
                                    "read_time": 0, "write_time": 0, "read_merged_count": 0,
                                    "write_merged_count": 0, "busy_time": 0},
                           description="The input/output count and time for the device")
    public_ip: str = Field(default="", description="The public IP address of the device")
    vpn_ip: str = Field(default="", description="The VPN IP address of the device")
    vpn_connected: bool = Field(default=False, description="The status of VPN connection of the device")
    firmware_version: str = Field(default="", description="The firmware version of the device")
    app_version: list = Field(default=[], description="The app version of the device")
    monitor_id: str = Field(default="", description="The monitor ID of the device")
    monitoring_list: str = Field(default="", description="The monitoring list of the device")
    cpu: dict = Field(default={"current": "", "overall_usage": "", "cpu_temp": "",
                               "each_cpu_usage": [0, 0]},
                      description="The CPU usage and temperature of the device")
    rssi: str = Field(default="", description="The RSSI value of the device")
    cts: int = Field(default=0, description="The CTS value of the device")
    rts: int = Field(default=0, description="The RTS value of the device")
    lts: int = Field(default=0, description="The LTS value of the device")
    ats: int = Field(default=0, description="The ATS value of the device")
    status: str = Field(default="", description="The status of the device")
    clear_sd: bool = Field(default=False, description="The status of clearing the SD card of the device")
    eth_ip: str = Field(default="", description="The Ethernet IP address of the device")
    username: str = Field(default="", description="The username of the device")
    date: str = Field(default="", description="The date of the device")
    network_name: str = Field(default="", description="The network name of the device")
    signal_quality: str = Field(default="", description="The signal quality of the device")
    firmware: dict = Field(default={}, description="The firmware details of the device")
    app: dict = Field(default={}, description="The app details of device")
    try_count: int = Field(default=0, description="Try count details of device")
    board_version: str = Field(default="", description="Board version of the device")
    terminal: str = Field(default="", description="terminal url of the device")
