import pymongo
import pytz

""" mongo dumping"""
import os
import subprocess
import zipfile
from datetime import datetime, timedelta
from schema import DeviceDetails, DeviceParameters


# # Set the MongoDB URL to connect to
# mongo_url = 'mongodb://ilens:ilens%401234@192.168.0.220:4720/?authSource=admin'

# # Set the path to the mongodump executable
# mongodump_path = 'C:/Program Files/MongoDB/Server/6.0/bin/mongodump.exe'

# # Set the name of the database to be dumped
# db_name = 'Iot_manager(Test)'

# # Set the path where the dump will be saved
# dump_path = 'E:/Iot_manager(Test)/dumped_data'

# # Build the command to be executed
# command = [mongodump_path, '--uri', mongo_url, '--db', db_name, '--out', dump_path]

# # Execute the command
# subprocess.call(command)

# # mongo restore

# mongorestore_path = 'C:/Program Files/MongoDB/Server/6.0/bin/mongorestore.exe'
# now = datetime.now()

# date_str = now.strftime("%Y-%m-%d")

# new_db_name = f"Iot_manager(Test)_copy_{date_str}"

# restore_command = [mongorestore_path, '--uri', mongo_url, '--db', new_db_name, dump_path + "/" + db_name]
# subprocess.call(restore_command)


# def zip_folder(folder_path, zip_path):
#     with zipfile.ZipFile(zip_path, 'w', compression=zipfile.ZIP_DEFLATED) as zip:
#         for root, dirs, files in os.walk(folder_path):
#             for file in files:
#                 file_path = os.path.join(root, file)
#                 zip.write(file_path, file_path[len(folder_path):])


# zip_folder(dump_path, 'E:/Iot_manager(Test)/dumped_data.zip')

# """ end of mongo dumping and backup"""

""" mongo migration"""
# set up the connection to MongoDB


client1 = pymongo.MongoClient("mongodb://ilens:ilens%401234@192.168.0.220:4720/")
col_list = ['mp201a', 'glens', 'ilens', 'ilens_ir4.0', 'dubai-munc', 'epda-rak', 'camw', 'ilens-avis', 'old_glens',
            'old_calixto', "ilens-mc"]
db1 = client1["Iot_manager(Test)"]

db2 = client1["Assets_manager"]
device_details = db2["Iot_devices_details"]
parameters_details = db2["Iot_device_Parameters_details"]

counter = 1
for collection_name in col_list:
    existing_collection = db1[collection_name]
    # query the collection to fetch documents
    documents = existing_collection.find({}, {"_id": 0})
    i = 0
    # print the document details
    for doc in documents:

        try:
            i += 1
            mac_address = doc.get("mac")
            if isinstance(mac_address, type(None)):
                mac_address = ""
            board_version = doc.get("board_version")
            if isinstance(board_version, type(None)):
                board_version = ""
            try_count = doc.get("try_count")
            if isinstance(try_count, type(None)):
                try_count = 0
            ram_total = doc.get("ram_total")
            if isinstance(ram_total, type(None)):
                ram_total = 0
            elif ram_total == "":
                ram_total = 0
            ram_used = doc.get("ram_used")
            if isinstance(ram_used, type(None)):
                ram_used = 0
            elif ram_used == "":
                ram_used = 0
            ram_free = doc.get("ram_free")
            if isinstance(ram_free, type(None)):
                ram_free = 0
            elif ram_free == "":
                ram_free = 0

            last_sync = doc.get("last_sync")
            if isinstance(last_sync, type(None)):
                last_sync = "2000-01-01 00:00:00"
            elif last_sync == "":
                last_sync = "2000-01-01 00:00:00"

            else:
                transformed_last_sync = datetime.strptime(last_sync, "%Y-%m-%dT%H:%M:%SZ").astimezone(
                    tz=pytz.timezone('Asia/Kolkata'))
                last_sync = transformed_last_sync.astimezone(pytz.UTC)

            throttle = doc.get("throttle")
            if isinstance(throttle, type(None)):
                throttle = ""
            public_ip = doc.get("public_ip")
            if isinstance(public_ip, type(None)):
                public_ip = ""
            vpn_ip = doc.get("vpn_ip")
            if isinstance(vpn_ip, type(None)):
                vpn_ip = ""
            firmware_version = doc.get("version")
            if isinstance(firmware_version, type(None)):
                firmware_version = ""
            site_name = doc.get("name")
            if isinstance(site_name, type(None)):
                site_name = ""
            site_id = doc.get("site_id")
            if isinstance(site_id, type(None)):
                site_id = ""
            tags = doc.get("tags")
            if isinstance(tags, type(None)):
                tags = []

            software_name = doc.get("softwareName")
            if isinstance(software_name, type(None)):
                software_name = ""

            cpu = doc.get("cpu")
            if isinstance(cpu, type(None)):
                cpu = {}
            network_name = doc.get("network_name")
            if isinstance(network_name, type(None)):
                network_name = ""
            eth_ip = doc.get("eth_ip")
            if isinstance(eth_ip, type(None)):
                eth_ip = ""
            ats = doc.get("ats")
            if isinstance(ats, type(None)):
                ats = 0
            cts = doc.get("cts")
            if isinstance(cts, type(None)):
                cts = 0
            rssi = doc.get("rssi")
            if isinstance(rssi, type(None)):
                rssi = ""
            signal_quality = doc.get("signal_quality")
            if isinstance(signal_quality, type(None)):
                signal_quality = ""
            app = doc.get("app")
            if isinstance(app, type(None)):
                app = {}
            firmware = doc.get("firmware")
            if isinstance(firmware, type(None)):
                firmware = {}
            date = doc.get("date")
            if isinstance(date, type(None)):
                date = ""
            username = doc.get("username")
            if isinstance(username, type(None)):
                username = ""
            clear_sd = doc.get("clear_sd")
            if isinstance(clear_sd, type(None)):
                clear_sd = False
            lts = doc.get("lts")
            if isinstance(lts, type(None)):
                lts = 0
            disk = doc.get("disk")
            if isinstance(disk, type(None)):
                disk = {}
            io_count = doc.get("io_count")
            if isinstance(io_count, type(None)):
                io_count = {}
            last_reboot = doc.get("last_reboot")
            if isinstance(last_reboot, type(None)):
                last_reboot = "2000-01-01 00:00:00"
            elif last_reboot == "":
                last_reboot = "2000-01-01 00:00:00"
            app_version = doc.get("app_version")
            if isinstance(app_version, str):
                temp = app_version
                app_version = [temp]
            elif isinstance(app_version, type(None)):
                app_version = []
            ram_percent = doc.get("ram_percent")
            if ram_percent == "":
                ram_percent = 0.00
            elif isinstance(ram_percent, type(None)):
                ram_percent = 0.00

            device_id = doc.get("deviceId")
            if isinstance(device_id, type(None)):
                device_id = ""
            if device_id == "":
                device_id = f"UNKNOWN_DEVICE_{counter:02}"
                counter += 1

            monitoring_list = doc.get("monitoring_list")
            # print(monitoring_list)
            if isinstance(monitoring_list, type(None)):
                monitoring_list = ""
            monitor_id = doc.get("monitor_id")
            if isinstance(monitor_id, type(None)):
                monitor_id = ""
            service_details = doc.get("service_details")
            if isinstance(service_details, type(None)):
                service_details = []
            status = doc.get("status")
            if isinstance(status, type(None)):
                status = ""
            vpn_connected = doc.get("vpn_connected")
            if isinstance(vpn_connected, type(vpn_connected)):
                vpn_connected = False

            # Find all devices with software_name="ilens-mc"

            # Concatenate each device ID with a common URL and store it as a separate kdevey matching the device ID

            terminal = doc.get("terminal")
            if isinstance(terminal, type(terminal)):
                terminal = ""
            if terminal == "":
                if software_name == "ilens-mc":
                    terminal = f"https://ilens.io/SCN/#/p/config/deviceConfig/{firmware_version}&iLens-SCN101&{device_id}"

            device_data = DeviceDetails(
                device_id=device_id,
                software_name=software_name,
                mac_address=mac_address,
                site_id=site_id,
                site_name=site_name,
                tags=tags,
                site_location={
                    "country": "",
                    "state": "",
                    "city": ""
                },
                customer="",
                vendor=""
            )
            parameter_data = DeviceParameters(
                mac_address=mac_address,
                software_name=software_name,
                ram_free=ram_free,
                ram_total=ram_total,
                ram_percent=ram_percent,
                ram_used=ram_used,
                disk=disk,
                last_reboot=last_reboot,
                last_sync=last_sync,
                throttle=throttle,
                io_count=io_count,
                vpn_ip=vpn_ip,
                public_ip=public_ip,
                vpn_connected=vpn_connected,
                firmware_version=firmware_version,
                app_version=app_version,
                cpu=cpu,
                monitoring_list=monitoring_list,
                monitor_id=monitor_id,
                service_details=service_details,
                status=status,
                signal_quality=signal_quality,
                ats=ats,
                eth_ip=eth_ip,
                network_name=network_name,
                date=date,
                firmware=firmware,
                board_version=board_version,
                username=username,
                app=app,
                try_count=try_count,
                cts=cts,
                clear_sd=clear_sd,
                rssi=rssi,
                lts=lts,
                terminal=terminal
            )

            device_details_status = device_details.insert_one(device_data.dict())
            if device_details_status.inserted_id:
                device_details.create_index("software_name")
                device_details.create_index("device_id")
                device_details.create_index("mac_address")

                parameters_details_status = parameters_details.insert_one(parameter_data.dict())
                if parameters_details_status.inserted_id:
                    parameters_details.create_index("mac_address")
                    parameters_details.create_index("last_sync")
                    parameters_details.create_index("software_name")
                else:
                    device_details.delete_one({"mac_address": mac_address})
            print(f"{collection_name} - {i}")

        except Exception as e:
            print(e)
