# importing libraries
from fastapi import APIRouter
from scripts.constants.endpoints import EndPoints
from scripts.constants.models import PrototypeCharacter
from scripts.core.handlers.api_functions import create_new_character
from scripts.logging.logger import logger

# Create FastAPI instance
prototype = APIRouter()


# Root
@prototype.get(EndPoints.root)
async def root():
    return {"Message": "It's Working!"}


# Create Characters
@prototype.post(EndPoints.create_characters)
def create_characters(prototypes: PrototypeCharacter):
    try:
        base_character, new_character = create_new_character(prototypes)
        return {"Base Character": base_character, "New Character": new_character}
    except Exception as e:
        logger.error(e)
