from scripts.core.handlers.prototyping import Character, CharacterPrototype
from scripts.logging.logger import logger


def create_new_character(prototypes):
    try:
        # Creates a prototype for a base character
        base_character = Character("Character", health=100, speed=5, damage=10, skills=12)

        # Creates a prototype object and register the base character
        prototype = CharacterPrototype()
        base_character_name = "normal_character"
        prototype.create_character(base_character_name, base_character)
        # Creates a new character by cloning the base character and updating its attributes
        new_character = prototype.clone(base_character_name,
                                        health=prototypes.health,
                                        speed=prototypes.speed,
                                        damage=prototypes.damage,
                                        skills=prototypes.skills)
        print(new_character)
        return base_character, new_character
    except Exception as e:
        logger.error(e)
