import copy


# Base Class
class Character:
    def __init__(self, name, health, speed, damage, skills):
        self.name = name
        self.health = health
        self.speed = speed
        self.damage = damage
        self.skills = skills

    def __str__(self):
        # Returns
        return f"{self.name} (health: {self.health}, speed: {self.speed}, damage: {self.damage}, skills: {self.skills})"


class CharacterPrototype:
    def __init__(self):
        self.character = {}

    # Method for creating new character
    def create_character(self, name, character):
        self.character[name] = character

    # Method for cloning the base character and update its attributes
    def clone(self, name, **attrs):
        character = copy.deepcopy(self.character.get(name))
        character.__dict__.update(attrs)
        return character
