import copy


class Character:
    def __init__(self, name, health, speed, damage, skills):
        self.name = name
        self.health = health
        self.speed = speed
        self.damage = damage
        self.skills = skills

    def __str__(self):
        # Returns
        return f"{self.name} (health: {self.health}, speed: {self.speed}, damage: {self.damage}, skills: {self.skills})"


class CharacterPrototype:
    def __init__(self):
        self.character = {}

    # Method for creating new character
    def create_character(self, name, character):
        self.character[name] = character

    # Method for cloning the base character and update its attributes
    def clone(self, name, **attrs):
        character = copy.deepcopy(self.character.get(name))
        character.__dict__.update(attrs)
        return character


# Creates a prototype for a base character
base_character = Character("Character", health=100, speed=5, damage=10, skills=12)

# Creates a prototype object and register the base character
prototype = CharacterPrototype()
prototype.create_character("normal_character", base_character)

# Creates a new character by cloning the base character and updating its attributes
four_star_character = prototype.clone("normal_character", speed=25, damage=25)
five_star_character = prototype.clone("normal_character", health=125, speed=30, damage=50)

# Printing the characters
print("Normal Character attribute:\n", base_character)
print("4 STAR Character attribute:\n", four_star_character)
print("5 STAR Character attribute:\n", five_star_character)
