from configparser import ConfigParser
from scripts.logging.logger import logger

try:
    config = ConfigParser()
    config.read("conf/application.conf")

    port_no = config.get("fastapi_connection", "port_no")

    broker = config.get("MQTT_Connection", "broker")
    mqtt_port = config.get("MQTT_Connection", "port")
    time_out = config.get("MQTT_Connection", "time_out")
    topic = config.get("MQTT_Connection", "topic")

except Exception as e:
    logger.error(e)
