import json
import time

from scripts.constants.application_config import topic
from scripts.constants.mqtt_connection import mqtt_client_connection
from scripts.logging.logger import logger


class Publishing:
    def __init__(self):
        self.mqtt_client = mqtt_client_connection()

    def send_data_to_subscriber(self, site_id, data_quality, site_data):
        try:
            message = {
                "data": {
                    "PM10": site_data.pm10,
                    "PM2.5": site_data.pm2_5,
                    "S02": site_data.s02,
                    "NO2": site_data.no2
                },
                "site_id": site_id,
                "data_quality": data_quality
            }
            self.mqtt_client.publish(topic, json.dumps(message))
            time.sleep(10)
            return "Data Published"
        except Exception as e:
            logger.error(e)
            return f"Data Sending error - {e}"
