# importing libraries
from fastapi import APIRouter
from scripts.constants.endpoints import EndPoints
from scripts.constants.models import SiteData
from scripts.core.handlers.api_functions import Publishing
from scripts.logging.logger import logger

# Create FastAPI instance
router = APIRouter()

# Create instance of Class Publishing
publisher = Publishing()


# Root
@router.get(EndPoints.root)
async def root():
    return {"Message": "It's Working!"}


@router.post(EndPoints.send_data)
async def send_data(site_id: int, data_quality: int, site_data: SiteData):
    try:
        message = publisher.send_data_to_subscriber(site_id, data_quality, site_data)
        return message
    except Exception as e:
        logger.error(e)
        return e
