import json

from scripts.config.application_config import topic
from scripts.constants.mqtt_connection import mqtt_client_connection
from scripts.core.handlers.store_in_redis import store_data_in_db
from scripts.logging.logger import logger


def on_message(client, userdata, message):
    data = message.payload.decode()
    print(f"Message send using topic : {message.topic}, Data received : {data}")
    json_data = json.loads(data)
    store_data_in_db(json_data)


def start_subscribing():
    try:
        # MQTT client for subscribing
        mqtt_client = mqtt_client_connection()
        print("Waiting for messages")
        mqtt_client.subscribe(topic)
        mqtt_client.on_message = on_message
        mqtt_client.loop_forever()
    except Exception as e:
        logger.error(e)
