import json
from scripts.constants.redis_connection import db_connection1, db_connection2, db_connection3
from scripts.logging.logger import logger


def store_data_in_db(json_data):
    try:
        quality = json_data["data_quality"]
        key = json_data["site_id"]
        value = json.dumps(json_data["data"])
        if quality == 0:
            # if data quality is Good
            db_connection1.set(key, value)
        elif quality == 1:
            # if data quality is Maintenance
            db_connection2.set(key, value)
        elif quality == 2:
            # if data quality is Error
            db_connection3.set(key, value)
    except Exception as e:
        logger.error(e)
