from configparser import ConfigParser

try:
    config = ConfigParser()
    config.read("conf/application.conf")

    port_no = config.get("fastapi_connection", "port_no")

    broker = config.get("MQTT_Connection", "broker")
    mqtt_port = config.get("MQTT_Connection", "port")
    time_out = config.get("MQTT_Connection", "time_out")

    host = config.get("redis_connection", "host")
    redis_port = config.get("redis_connection", "redis_port")
    good_data = config.get("redis_connection", "good_data")
    maintenance_data = config.get("redis_connection", "maintenance_data")
    error_data = config.get("redis_connection", "error_data")

except Exception as e:
    print("Exception-", e)




