import random
from datetime import datetime
from pymodbus.client.sync import ModbusTcpClient
from azure.iot.device import IoTHubDeviceClient, Message

# Modbus TCP/IP connection settings
modbus_host = "192.168.1.1"
modbus_port = 502
modbus_slave_id = 1
modbus_address = 0  # start address to read from
modbus_count = 10  # number of registers to read

# Define the JSON message to send to IoT Hub.
TEMPERATURE = 20.0
HUMIDITY = 60

# Azure IoT Hub connection string and message settings
connection_string = "HostName=ajil.azure-devices.net;DeviceId=iot_device1;SharedAccessKey" \
                    "=dnHYnjY8RpQHtUlmeJAhygoOVdFX5xBNjgM/qm5FZ80="
temperature = TEMPERATURE + (random.random() * 15)
humidity = HUMIDITY + (random.random() * 20)
epoch = datetime.now().timestamp()
message = '{{"epoch": {0}, "temperature": {1}, "humidity": {2}}}'.format(epoch, temperature, humidity)

message = Message("hello from Modbus device")

# Create Modbus TCP client and connect to device
client = ModbusTcpClient(modbus_host, port=modbus_port)
client.connect()

# Read data from Modbus device
result = client.read_holding_registers(modbus_address, modbus_count, unit=modbus_slave_id)

# Create Azure IoT Hub client and connect to device
device_client = IoTHubDeviceClient.create_from_connection_string(connection_string)
device_client.connect()

# Send data to Azure IoT Hub
device_client.send_message(message)

# Disconnect from Modbus device and Azure IoT Hub
client.close()
device_client.disconnect()
