import random
import time
from datetime import datetime
import paho.mqtt.client as mqtt

# Set the connection string for your device
iot_hub_name = "ajil"
device_id = "iot_device1"
sas_token = "SharedAccessSignature sr=ajil.azure-devices.net%2Fdevices%2Fiot_device1&sig=uJM96e2IYKU0%2FQb" \
            "%2Bq9sJAKCLGvJc04oFKoj%2BtLtXIbc%3D&se=1677580978"

# Define the message that send to IoT Hub.
TEMPERATURE = 20.0
HUMIDITY = 60


def mqtt_client_init():
    # Create an MQTT client
    client = mqtt.Client(client_id=device_id, protocol=mqtt.MQTTv311, clean_session=False)
    return client


def iot_hub_client_telemetry_run():
    try:
        # Create MQTT client

        # Create an instance of the MQTT client
        client = mqtt_client_init()
        client.tls_set_context(context=None)

        # Set the username and password for the MQTT client
        username = "{0}.azure-devices.net/{1}/api-version=2018-06-30".format(iot_hub_name, device_id)
        client.username_pw_set(username=username, password=sas_token)

        # Connect to the IoT Hub using MQTT
        client.connect(iot_hub_name + ".azure-devices.net", port=8883)
        while True:
            # Build the message with simulated telemetry values.
            temperature = TEMPERATURE + (random.random() * 15)
            humidity = HUMIDITY + (random.random() * 20)
            epoch = datetime.now().timestamp()
            message = '{{"epoch": {0}, "temperature": {1}, "humidity": {2}}}'.format(epoch, temperature, humidity)

            # Send the message to the IoT Hub using MQTT
            print("Sending message: {}".format(message))
            client.publish("devices/{0}/messages/events/".format(device_id), payload=message, qos=1, retain=False)
            print("Message successfully sent")
            time.sleep(10)
    except KeyboardInterrupt:
        print("IoTHubClient stopped")


if __name__ == '__main__':
    print("IoT Hub Quickstart #1 - Simulated device")
    print("Press Ctrl-C to exit")
    iot_hub_client_telemetry_run()
