# Azure-CosmosDB

1. An Azure Cosmos DB API for MongoDB is created in the Azure Portal and Capacity is chosen as Provisioned Throughput.
1. A fresh mongo dump is taken and restored to Azure CosmosDB account using a Python Script.
1. After the dump is successfully restored, the database and collections can be seen  in the Data Explorer Panel as follows: 
<img src="https://gitlab-pm.knowledgelens.com/abhinandan.joshi/azure-cosmosdb/-/raw/master/images/img9.jpg"/>

Based on the above data, a few observations are made:
1. After 12 hours of creating an account and restoring the Mongo Dump, **12 USD** was charged.
1. After more than 24 hours, **33 USD** was charged.
1. After  28-30 hours, **15 USD** was charged.
1. After 48 hours, **25 USD** was charged.

Totally around 85 USD has been charged. And then, the database was removed and the account was kept as it is.

The following screenshots can be used to get an idea of the **Throughput and estimated costs** by the databases:

Screenshot 1 : **Depicts the start of the Browse panel**

<img src="https://gitlab-pm.knowledgelens.com/abhinandan.joshi/azure-cosmosdb/-/raw/master/images/img12.jpg"/>


Screenshot 2 : **Depicts the mid of the Browse panel**

<img src="https://gitlab-pm.knowledgelens.com/abhinandan.joshi/azure-cosmosdb/-/raw/master/images/img13.jpg"/>



Screenshot 3 : **Depicts the end of the Browse panel**

<img src="https://gitlab-pm.knowledgelens.com/abhinandan.joshi/azure-cosmosdb/-/raw/master/images/img16.jpg"/>

**Inference** : It can be inferred that the total throughput(in Request Units/second) is **48,400**.

**Reason for Total Throughput Value**: 
There are two methods of provisioning throughput while creating the Azure Cosmos DB Account -  
* [ ] Collection Level
* [ ] Database Level 

<img src="https://gitlab-pm.knowledgelens.com/abhinandan.joshi/azure-cosmosdb/-/raw/master/images/img17.jpg"/>

If not specified explicitly, then *Collection level will be chosen by default*.
As specified in the above figure, minimum 400 RU/s per collection. So totally 12 Collections. 12*400 = 4800 RU.

The following screenshots of **Activity Log** can be used to get an idea of the different activities that were triggered in the CosmosDB Account:


**Screenshot 1**
<img src="https://gitlab-pm.knowledgelens.com/abhinandan.joshi/azure-cosmosdb/-/raw/master/images/img20.jpg"/>
**Screenshot 2**
<img src="https://gitlab-pm.knowledgelens.com/abhinandan.joshi/azure-cosmosdb/-/raw/master/images/img21.jpg"/>

The above screenshots were taken before the databases were deleted in the CosmosDB account. 

**Screenshot 3** : This screenshot was taken after DBs were removed from the Account.
<img src="https://gitlab-pm.knowledgelens.com/abhinandan.joshi/azure-cosmosdb/-/raw/master/images/img24.jpg"/>

The reason for which the amount was charged can be concluded as follows :
According to the screenshots from Activity Log, there are few operations which get triggered in a certain intervals of time, which perform one of the following Operations : Read,Insert, Upsert, Delete and Query. 
The RU will be charged for these activities as follows: 

<img src="https://gitlab-pm.knowledgelens.com/abhinandan.joshi/azure-cosmosdb/-/raw/master/images/img25.jpg"/>









