import os
from dotenv import load_dotenv
load_dotenv()  # take environment variables from .env.

JOB_ID=os.environ.get('JOB_ID')

LOG_LEVEL = os.environ.get("LOG_LEVEL", "DEBUG").upper()
LOGSTASH_HOST = os.environ.get("LOGSTASH_HOST", None)
LOGSTASH_PORT = os.environ.get("LOGSTASH_PORT", None)
LOG_HANDLER_NAME = os.environ.get("LOG_HANDLER_NAME", "MovingAverageComponent")
BASE_LOG_PATH = os.path.join(os.getcwd(), "logs".format())

KAIROS_API_URL=os.environ.get("KAIROS_API_URL").strip()
KAIROS_METRC_NAME=os.environ.get("KAIROS_METRC_NAME").strip()
KAIROS_TAG_NAME = os.environ.get('KAIROS_TAG_NAME', 'c3').strip()

IS_API = os.environ.get('IS_API', 'false').strip().lower() # boolean flag stating is the module run from component or an api
if IS_API == 'false':
    HIRARCHY_TAGS = os.environ.get('HIRARCHY_TAGS').strip().split(',') # comma separated ilens hirarchy tags
    INPUT_TAGS = os.environ.get('INPUT_TAGS').strip().split(',') # comma separated data tags for forecasting 
    OUTPUT_TAGS = os.environ.get('OUTPUT_TAGS').strip().split(',') # comma separated data tags to push forecasted data
    START_TIMESTAMP = os.environ.get('START_TIMESTAMP', '').strip() # absolute or relative timestamp with respect to today plus offset  or exact UTC timestamp in sec or use last historical timestamp plus offset Ex: today+1 or 1642703400 or last+1
    NUMBER_FORCASTS = int(os.environ.get('NUMBER_FORCASTS').strip()) # number of future datapoints to forecast
    FREQUENCY = os.environ.get('FREQUENCY').strip() # frequency of the datapoint in kairos : Available Values [seconds, minutes, hours, days, weeks, months, years]
    FILTER_TAG = os.environ.get('FILTER_TAG', '').strip().split(',') # comma separated tag name on which datapoints are to be filtered  
    FILTER_VALUE = os.environ.get('FILTER_VALUE', "0").strip().split(',') # comma separated value that needs to be filtered out
    FILTER_CONDITION = os.environ.get('FILTER_CONDITION', "ne").strip().split(',') # comma separated condition of the filter to be applied : Available Values [equal, ne, lt, lte, gt, gte]
    RELATIVE_END = int(os.environ.get('RELATIVE_END', '0').strip()) # relative end datapoint number to consider for historical data default is 1


    config = {
            "KAIROS_API_URL":KAIROS_API_URL,
            "KAIROS_METRC_NAME":KAIROS_METRC_NAME,
            "KAIROS_TAG_NAME":KAIROS_TAG_NAME,
            "HIRARCHY_TAGS":HIRARCHY_TAGS,
            "INPUT_TAGS":INPUT_TAGS,
            "OUTPUT_TAGS":OUTPUT_TAGS,
            "START_TIMESTAMP":START_TIMESTAMP,
            "NUMBER_FORCASTS":NUMBER_FORCASTS,
            "FREQUENCY":FREQUENCY,
            "FILTER_TAG":FILTER_TAG,
            "FILTER_VALUE":FILTER_VALUE,
            "FILTER_CONDITION":FILTER_CONDITION,
            "RELATIVE_END":RELATIVE_END
        }