from scripts.utils.logsetup import logger

def get_kairos_json(metric, forecast_data, tags_json):
    temp_json = {
            "name": metric,
            "datapoints": forecast_data,
            "tags": tags_json
                }
    return temp_json

def tag_na_value_check(tag_value, tag_id):
    if logger.restrict_na_value_push and tag_value in [None, 'NA', 'nan', 'Nan', 'NAN']:
        logger.info(f"Invalid tag value Tag:{tag_id}  Value: {tag_value}")
        return True
    return False

def tag_none_value_check(tag_value, tag_id):
    if tag_value is None:
        logger.error(f" Invalid tag value found for the tag ID: {tag_id} and value: {tag_value}")
        return True
    return False

def get_tags_json(tag_id):
    return {
            "c3": tag_id,
            "c1": tag_id.split("$")[0],
            "c5": tag_id.split("$")[-1]
            }