import os
from dotenv import load_dotenv
load_dotenv()  # take environment variables from .env.

JOB_ID=os.environ.get('JOB_ID')

LOG_LEVEL = os.environ.get("LOG_LEVEL", "DEBUG").upper()
LOGSTASH_HOST = os.environ.get("LOGSTASH_HOST", None)
LOGSTASH_PORT = os.environ.get("LOGSTASH_PORT", None)
LOG_HANDLER_NAME = os.environ.get("LOG_HANDLER_NAME", "MovingAverageComponent")
BASE_LOG_PATH = os.path.join(os.getcwd(), "logs".format())

KAIROS_API_URL=os.environ.get("KAIROS_API_URL").strip()
KAIROS_METRC_NAME=os.environ.get("KAIROS_METRC_NAME").strip()
KAIROS_TAG_NAME = os.environ.get('KAIROS_TAG_NAME', 'c3').strip()

HIRARCHY_TAGS = os.environ.get('HIRARCHY_TAGS').strip().split(',') # comma seperated ilens hirarchy tags
INPUT_TAGS = os.environ.get('INPUT_TAGS').strip().split(',') # comma seperated data tags for forecasting 
OUTPUT_TAGS = os.environ.get('OUTPUT_TAGS').strip().split(',') # comma seperated data tags to push forecasted data
START_TIMESTAMP = os.environ.get('START_TIMESTAMP').strip() # absolute or relative timestamp with respect to today or exact UTC timestamp in sec Ex: today+1 or 1642703400
NUMBER_FORCASTS = int(os.environ.get('NUMBER_FORCASTS').strip()) # number of future datapoinst to forecast
FREQUENCY = os.environ.get('FREQUENCY').strip() # frequency of the datapoint in kairos : Avalable Values [seconds, minutes, hours, days, weeks, months, years]
FILTER_TAG = os.environ.get('FILTER_TAG', '').strip() # full tag name with hirarchy on which datapoinst are to be filtered  
FILTER_VALUE = float(os.environ.get('FILTER_VALUE', "0").strip()) # value that needs to be filtered out
FILTER_CONDITION = os.environ.get('FILTER_CONDITION', "ne").strip() # condition of the filter to be applied : Avalable Values [equal, ne, lt, lte, gt, gte]
RELATIVE_END = int(os.environ.get('RELATIVE_END', '1').strip()) # relative end datapoint number to concider for historical data default is 1
