if __name__ == "__main__":
    from dotenv import load_dotenv
    load_dotenv(dotenv_path='config.env')
import warnings
from loguru import logger
import tracemalloc
import gc
from scripts.utils.start_end_date import KairosStartEndDate
from scripts.core.engine.raw_predicted_tags import get_raw_predicted_tags
from scripts.core.engine.ml_modelling import AiModelling
warnings.filterwarnings("ignore")


start_date, end_date, start_timestamp, end_timestamp = KairosStartEndDate().start_end_date()
logger.info(f'start date - {start_date}')
logger.info(f'end date - {end_date}')


def orchestrator():
    try:
        tracemalloc.start()
        print(f'initial memory usage - {tracemalloc.get_traced_memory()}')
        gc.collect()
        tracemalloc.reset_peak()
        tracemalloc.clear_traces()
        print(tracemalloc.get_traced_memory())
        df_raw_tags, df_predicted_tags, df_coefficients = get_raw_predicted_tags()

        logger.info(f'raw tags dataframe shape - {df_raw_tags.shape}')
        logger.info(f'predicted tags dataframe shape - {df_predicted_tags.shape}')

        ai_modelling = AiModelling(df_raw_tags=df_raw_tags, df_coefficients=df_coefficients,
                                   start_timestamp=start_timestamp, end_timestamp=end_timestamp)
        ai_modelling.all_calculations()
        del ai_modelling

        tracemalloc.stop()
    except Exception as e:
        logger.exception(f'Exception - {e}')


if __name__ == '__main__':
    orchestrator()

