import pandas as pd
from loguru import logger
from scripts.utils.preprocessing import DataPreprocessing
from scripts.utils.mlflow_util import ModelLoad


class Training:
    def __init__(self, df):
        self.df = df

    def data_training(self, inv_id, mppt_id):
        try:
            df_std = self.df[['tilt_irradiance', 'voltage_mppt', 'hour', 'current_mppt']]
            # df_std.drop([''])
            df_std.dropna(axis=0, inplace=True)
            df_std.reset_index(drop=True, inplace=True)
            inv_mppt_id = f'{inv_id}_{mppt_id}'
            ModelLoad().model_manager(df=df_std, target='current_mppt',
                                      inv_mppt_id=inv_mppt_id, city='ariyalur')

        except Exception as e:
            logger.exception(f'Exception - {e}')
