from loguru import logger
from scripts.utils.mlflow_util import ModelLoad


class Inference:
    def __init__(self, df):
        self.df = df

    def data_inference(self, inv_id, mppt_id):
        try:
            df_test_mppt = self.df[['datetime', 'tilt_irradiance', 'voltage_mppt', 'hour', 'current_mppt']]
            df_test_mppt.reset_index(drop=True, inplace=True)
            x_test = df_test_mppt[['datetime', 'tilt_irradiance', 'voltage_mppt', 'hour']]
            y_test = df_test_mppt[['current_mppt']]

            logger.debug(f'shape of x_test for {inv_id} & {mppt_id} - {x_test.shape}')
            logger.debug(f'shape of y_test for {inv_id} & {mppt_id} - {y_test.shape}')

            inv_mppt_id = f'{inv_id}_{mppt_id}'

            model = ModelLoad().model_manager(inv_mppt_id=inv_mppt_id)

            predictions = model.predict(x_test.drop(['datetime'], axis=1)).reshape(1, -1)
            return x_test, y_test, predictions

        except Exception as e:
            logger.exception(f'Exception - {e}')
