from loguru import logger
import pandas as pd


class GetTags:
    def __init__(self, base_path):
        self.base_path = base_path

    def read_tag_excel(self):
        try:
            df = pd.read_excel(f'{self.base_path}/tags_download.xlsx')
            df.drop(['Site', 'Plant', 'Line', 'Tag'], axis=1, inplace=True)
            df.rename(columns={'Tag ID': 'tag_id', 'Tag Name': 'tag_name',
                               'Equipment': 'inv_id', 'Parameter Name': 'parameter_name'}, inplace=True)
            return df
        except Exception as e:
            logger.exception(f'Exception - {e}')

    def get_mppt_tags(self, df, substrings):
        try:
            data_with_substring = self.get_substring_data(substrings=substrings, df=df, column='parameter_name')
            req_data_list = self.removed_substring(substring_data_list=data_with_substring,
                                                   remove_parameter='Efficiency')
            df = self.get_substring_df(df=df, column='parameter_name', substring_data_list=req_data_list)
            df.reset_index(drop=True, inplace=True)
            df['parameter_name'] = df['parameter_name'].str.replace('Voltage MPPT ', 'voltage_mppt_')
            df['parameter_name'] = df['parameter_name'].str.replace('Current MPPT ', 'current_mppt_')
            df['inv_id'] = df['inv_id'].str.replace('INV ', 'inv_')
            df['inv_id'] = df['inv_id'].str.replace('Plant ', 'plant')
            df['mppt_id'] = df['parameter_name'].copy()
            df['mppt_id'] = df['mppt_id'].str.replace('current_', '')
            df['mppt_id'] = df['mppt_id'].str.replace('voltage_', '')
            df = df.sort_values(['inv_id', 'mppt_id'])
            df['mppt_id_with_equipment'] = df['parameter_name'] + '_' + df['inv_id']
            df.reset_index(drop=True, inplace=True)
            return df
        except Exception as e:
            logger.exception(f'Exception - {e}')

    @staticmethod
    def get_tags_id(df, inv_id):
        try:
            df = df[df['inv_id'] == inv_id]
            df = df[['tag_id', 'tag_name', 'inv_id', 'parameter_name', 'mppt_id',
                     'mppt_id_with_equipment']]
            df.reset_index(drop=True, inplace=True)
            return df
        except Exception as e:
            logger.exception(f'Exception - {e}')

    @staticmethod
    def get_substring_data(substrings, df, column):
        try:
            req_substrings = substrings
            data_with_substring = [data for data in df[column] if req_substrings in data]
            return data_with_substring
        except Exception as e:
            logger.exception(f'Exception - {e}')

    @staticmethod
    def removed_substring(substring_data_list, remove_parameter):
        try:
            req_data_list = [data for data in substring_data_list if remove_parameter not in data]
            return req_data_list
        except Exception as e:
            logger.exception(f'Exception - {e}')

    @staticmethod
    def get_substring_df(df, column, substring_data_list):
        try:
            df = df.loc[df[column].isin(substring_data_list)]
            df.reset_index(drop=True, inplace=True)
            return df
        except Exception as e:
            logger.exception(f'Exception - {e}')



