import pandas as pd
from loguru import logger


class GetFinalDf:
    @staticmethod
    def get_final_data(x_test, y_test, predictions):
        try:
            df_result = pd.DataFrame(index=[i for i in range(len(y_test))])
            df_result['datetime'] = x_test['datetime']
            df_result['actual_current_mppt'] = y_test
            df_result['predicted_current_mppt'] = predictions
            df_result.drop(['actual_current_mppt'], axis=1, inplace=True)
            df_result = df_result.round(2)
            df_result.reset_index(drop=True, inplace=True)
            logger.info(f'{df_result.shape}')
            return df_result
        except Exception as e:
            logger.exception(f'Exception - {e}')

    @staticmethod
    def get_predicted_current_tags(tags_excel):
        try:
            df = tags_excel.copy()
            df['parameter_name'] = df['parameter_name'].str.replace('Potential Current MPPT ',
                                                                    'potential_current_mppt_')
            df['inv_id'] = df['inv_id'].str.replace('INV ', 'inv_')
            df['mppt_id'] = df['parameter_name'].copy()
            df['mppt_id'] = df['mppt_id'].str.replace('potential_current_', '')
            req_substrings = 'mppt_'
            data_with_substring = [data for data in df['mppt_id'] if req_substrings in data]
            df = df.loc[df['mppt_id'].isin(data_with_substring)]
            df = df.sort_values(['inv_id', 'mppt_id'])
            df.reset_index(drop=True, inplace=True)
            return df
        except Exception as e:
            logger.exception(f'Exception - {e}')

    @staticmethod
    def get_final_predicted_tags(df_predicted_current_tags, inv_id, mppt_id):
        try:
            df = df_predicted_current_tags[df_predicted_current_tags['inv_id'] == inv_id]
            df = df[df['mppt_id'] == mppt_id]
            df.reset_index(drop=True, inplace=True)
            final_dict = {}
            for index in range(df.shape[0]):
                tag_id = df.iloc[index, df.columns.get_loc('tag_id')]
                parameter_name = df.iloc[index, df.columns.get_loc('parameter_name')]
                final_dict['predicted_current_mppt'] = tag_id
            return final_dict
        except Exception as e:
            logger.exception(f'Exception - {e}')