import pandas as pd
from loguru import logger
import warnings
from scripts.utils.mongo_utils import MongoConnect
from scripts.constants.app_configuration import Mongo
from scripts.constants.app_constants import MongoConstants
warnings.filterwarnings('ignore')


def get_raw_predicted_tags():
    try:
        mongo_conn = MongoConnect(uri=Mongo.mongo_uri, database=MongoConstants.db,
                                  collection=MongoConstants.collection)
        logger.debug(f'mongo conn - {mongo_conn}')
        raw_tags_dict = mongo_conn.find_one({"$and": [{"id": "dalmia_string_level_tags"}, {"city": "ariyalur"},
                                                      {"tags_property": "raw"}]})
        req_tags = raw_tags_dict['input_data']
        logger.info(f'raw tags dict - {req_tags}')
        df_raw_tags = pd.DataFrame.from_dict(req_tags, orient='index')

        predicted_tags_dict = mongo_conn.find_one({"$and": [{"id": "dalmia_string_level_tags"}, {"city": "ariyalur"},
                                                            {"tags_property": "predicted"}]})
        predicted_tags = predicted_tags_dict['input_data']
        logger.info(f'predicted tags dict - {predicted_tags}')
        df_predicted_tags = pd.DataFrame.from_dict(predicted_tags, orient='index')

        df_raw_tags.reset_index(inplace=True)
        df_raw_tags.rename(columns={'index': 'tag_name'}, inplace=True)
        df_predicted_tags.reset_index(inplace=True)
        df_predicted_tags.rename(columns={'index': 'tag_name'}, inplace=True)
        return df_raw_tags, df_predicted_tags
    except Exception as e:
        logger.exception(f'Exception - {e}')
