if __name__ == "__main__":
    from dotenv import load_dotenv
    load_dotenv(dotenv_path='config.env')
import os
import os.path
import sys
from configparser import ConfigParser, BasicInterpolation
import yaml
from loguru import logger

# Configuring file constants
data_conf = "./conf/data.yml"


class EnvInterpolation(BasicInterpolation):
    """
    Interpolation which expands environment variables in values.
    """

    def before_get(self, parser, section, option, value, defaults):
        value = super().before_get(parser, section, option, value, defaults)

        if not os.path.expandvars(value).startswith("$"):
            return os.path.expandvars(value)
        else:
            return


try:
    config = ConfigParser(interpolation=EnvInterpolation())
    config.read(f"conf/application.conf")
except Exception as e:
    print(f"Error while loading the config: {e}")
    print("Failed to Load Configuration. Exiting!!!")
    sys.exit()


class KairosDb:
    uri = config["KAIROS_DB"]["uri"]
    metric_name = config['KAIROS_DB']['metric_name']
    aggregator = config['KAIROS_DB']['aggregator']
    aggregator_value = config['KAIROS_DB']['aggregator_value']
    aggregator_unit = config['KAIROS_DB']['aggregator_unit']


class Kafka:
    kafka_host = config["KAFKA"]["kafka_host"]
    kafka_port = config["KAFKA"]["kafka_port"]
    kafka_topic = config["KAFKA"]["kafka_topic"]


class DateRange:
    start_date = config.get("DATE_RANGE", "start_date")
    end_date = config.get("DATE_RANGE", "end_date")
    start_relative_days = config.get("DATE_RANGE", "start_relative_days")
    end_relative_days = config.get("DATE_RANGE", "end_relative_days")


class ReqTimeZone:
    required_tz = config.get('TIMEZONE', 'required_tz')


class MlFlow:
    mlflow_tracking_uri = config['MLFLOW']['mlflow_tracking_uri']
    mlflow_tracking_username = config['MLFLOW']['mlflow_tracking_username']
    mlflow_tracking_password = config['MLFLOW']['mlflow_tracking_password']
    azure_storage_connection_string = config['MLFLOW']['azure_storage_connection_string']
    azure_storage_access_key = config['MLFLOW']['azure_storage_access_key']
    user = config['MLFLOW']['user']
    experiment_name = config['MLFLOW']['experiment_name']
    run_name = config['MLFLOW']['run_name']
    model_name = config['MLFLOW']['model_name']
    check_param = config['MLFLOW']['check_param']
    model_check_param = config['MLFLOW']['model_check_param']


class PycaretParams:
    model_list = config['PYCARET']['models_list']
    selected_metric = config['PYCARET']['selected_metric']
    hyperparameter_tuning_method= config['PYCARET']['hyperparameter_tuning_method']


class Mongo:
    mongo_uri = config["MONGO"]["mongo_uri"]
    project_id = config["MONGO"]["project_id"]
    query_filter = config["MONGO"]["query_filter"]















