import pandas as pd

if __name__ == "__main__":
    from dotenv import load_dotenv
    load_dotenv(dotenv_path='config.env')
import warnings
import numpy as np
from loguru import logger
from scripts.core.engine.mppt_data import GetData
from scripts.core.engine.tags_data import get_tags_data
from scripts.utils.start_end_date import KairosStartEndDate
from scripts.utils.preprocessing import DataPreprocessing
from scripts.core.engine.inv_and_mppt_level import TrainingInference
from scripts.core.engine.final_tags import GetFinalDf
from scripts.core.engine.model_training_inference import ai_modelling
from scripts.core.engine.raw_predicted_tags import get_raw_predicted_tags
warnings.filterwarnings("ignore")


base_path = 'data_folder'
start_date, end_date, start_timestamp, end_timestamp = KairosStartEndDate().start_end_date()


def get_tag_details():
    try:
        df_raw_tags, df_predicted_tags = get_raw_predicted_tags()
        logger.info(f'raw tags dataframe shape - {df_raw_tags.shape}')
        logger.info(f'predicted tags dataframe shape - {df_predicted_tags.shape}')

        df = get_tags_data(tags=df_raw_tags, start_timestamp=start_timestamp, end_timestamp=end_timestamp)
        logger.info(f'Shape of final df - {df.shape}')

        mppt_data = GetData()
        df_mppt = mppt_data.current_voltage_mppt_data(df=df)

        data_preprocessing = DataPreprocessing()
        df_mppt = data_preprocessing.remove_outliers(df=df_mppt, param_list=['tilt_irradiance', 'voltage_mppt',
                                                                             'current_mppt'])

        df_mppt, df_train, df_test = data_preprocessing.train_test_split(df=df_mppt)
        get_training_inference = TrainingInference(df=df_mppt, df_train=df_train, df_test=df_test)
        ai_modelling(df_train=df_train, get_training_inference=get_training_inference,
                     df_predicted_tags=df_predicted_tags)
    except Exception as e:
        logger.exception(f'Exception - {e}')


if __name__ == '__main__':
    get_tag_details()

